/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.api.feature.EnumMode;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.AllStandSwitchModeData;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class AllStandSwitchModePacket
implements IPacket<AllStandSwitchModeData> {
    @Override
    public void encode(AllStandSwitchModeData data, FriendlyByteBuf buf) {
        buf.writeInt(data.mode.getIndex());
    }

    @Override
    public AllStandSwitchModeData decode(FriendlyByteBuf buf) {
        int mode_id = buf.readInt();
        EnumMode mode = EnumMode.byIndex(mode_id);
        return new AllStandSwitchModeData(mode);
    }

    @Override
    public void handle(AllStandSwitchModeData data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LogicalSide side = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide();
            if (!side.isServer()) {
                return;
            }
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender.m_36335_().m_41519_((Item)DoggyItems.WHISTLE.get())) {
                return;
            }
            EnumMode target_mode = data.mode;
            if (target_mode.canWander()) {
                return;
            }
            Predicate<Dog> switch_mode_target = filter_dog -> filter_dog.isDoingFine() && !filter_dog.m_21827_() && filter_dog.m_21830_((LivingEntity)sender) && filter_dog.getMode() != target_mode && !filter_dog.getMode().canWander();
            List dogs = sender.m_9236_().m_6443_(Dog.class, sender.m_20191_().m_82377_(100.0, 50.0, 100.0), switch_mode_target);
            for (Dog dog : dogs) {
                dog.setMode(target_mode);
            }
            sender.m_9236_().m_5594_(null, sender.m_20183_(), DoggySounds.WHISTLE_LONG.get(), SoundSource.PLAYERS, 0.6f + sender.m_9236_().f_46441_.m_188501_() * 0.1f, 0.4f + sender.m_9236_().f_46441_.m_188501_() * 0.2f);
            sender.m_213846_((Component)Component.m_237110_((String)"dogcommand.all_stand_switch_mode", (Object[])new Object[]{Component.m_237115_((String)data.mode.getUnlocalisedName()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)))}));
            sender.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 40);
        });
        ctx.get().setPacketHandled(true);
    }
}

